/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GobloEntity
extends GoblinEntity
implements ContainerListener {
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(GobloEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_CHICKEN = SynchedEntityData.m_135353_(GobloEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.m_135353_(GobloEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int eatTicks;
    private SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;

    public GobloEntity(EntityType<? extends GobloEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21553_(true);
        this.initInventory();
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    private void setSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)isSleeping);
    }

    public boolean hasChicken() {
        return (Boolean)this.f_19804_.m_135370_(HAS_CHICKEN);
    }

    private void setHasChicken(boolean hasChicken) {
        this.f_19804_.m_135381_(HAS_CHICKEN, (Object)hasChicken);
    }

    public boolean canDespawn(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new SleepGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new PickUpChickenGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FindItemsGoal());
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return SoundInit.GOBLO_SNORING;
        }
        return SoundInit.GOBLO_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundInit.GOBLO_HURT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.GOBLO_DEATH;
    }

    protected void initInventory() {
        SimpleContainer inventory = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (inventory != null) {
            inventory.m_19181_((ContainerListener)this);
            int i = Math.min(inventory.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.func_230275_fc_();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void func_230275_fc_() {
        if (!this.f_19853_.f_46443_) {
            this.setWatchableBoolean(4, !this.inventory.m_8020_(0).m_41619_());
        }
    }

    protected boolean getWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & p_110233_1_) != 0;
    }

    protected void setWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(STATUS);
        if (p_110208_2_) {
            this.f_19804_.m_135381_(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.f_19804_.m_135381_(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 25.0);
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, p_28602_);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_142081_());
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stackIn);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.canEquipItem(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
            this.eatTicks = 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            float f = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.nextFloat() < f * 0.3f) {
                entityIn.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATUS, (Object)0);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(HAS_CHICKEN, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsSleeping", this.m_5803_());
        compound.m_128379_("HasChicken", this.hasChicken());
        ListTag listnbt = new ListTag();
        for (int i = 2; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.m_128365_("Items", (Tag)listnbt);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleeping(compound.m_128471_("IsSleeping"));
        this.setHasChicken(compound.m_128471_("HasChicken"));
        ListTag listnbt = compound.m_128437_("Items", 10);
        this.initInventory();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            if (j < 2 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.inventory.m_19195_().forEach(arg_0 -> ((GobloEntity)this).m_19983_(arg_0));
    }

    protected ItemStack addToInventory(ItemStack p_234436_1_) {
        return this.inventory.m_19173_(p_234436_1_);
    }

    protected boolean canAddToInventory(ItemStack p_234437_1_) {
        return this.inventory.m_19183_(p_234437_1_);
    }

    @Override
    protected void finishConversion(ServerLevel p_234416_1_) {
        GoblinEntity.cancelAdmiring(this);
        this.inventory.m_19195_().forEach(arg_0 -> ((GobloEntity)this).m_19983_(arg_0));
        super.finishConversion(p_234416_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vector3d = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_ + 0.05, vector3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected int getInventorySize() {
        return 256;
    }

    protected void m_5907_() {
        super.m_5907_();
    }

    public SoundEvent getEatSound(ItemStack itemStackIn) {
        return SoundInit.GOBLO_EATING;
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            ++this.eatTicks;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            ItemStack air = Items.f_41852_.m_7968_();
            if (this.canEatItem(itemstack)) {
                if (this.eatTicks > 100 && itemstack.m_41720_().m_41472_()) {
                    if (itemstack.m_41720_() == Items.f_42732_) {
                        ItemStack itemstack1 = itemstack.m_41671_(this.f_19853_, (LivingEntity)this);
                        if (!itemstack1.m_41619_()) {
                            this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                        }
                        this.setSleeping(true);
                    }
                    this.eatTicks = 0;
                    itemstack.m_41774_(1);
                } else if (this.eatTicks > 100) {
                    ItemStack itemstack1 = itemstack.m_41671_(this.f_19853_, (LivingEntity)this);
                    if (!itemstack1.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.inventory.m_19173_(itemstack);
                    this.m_8061_(EquipmentSlot.MAINHAND, air);
                    this.eatTicks = 0;
                } else if (this.eatTicks > 60 && this.f_19796_.nextFloat() < 0.1f && this.m_21033_(EquipmentSlot.MAINHAND)) {
                    this.m_5496_(this.getEatSound(itemstack), 1.0f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
            }
        }
        if (!this.m_20160_()) {
            this.setHasChicken(false);
        }
        Vec3 vector3d = this.m_20184_();
        if (!this.f_19861_ && vector3d.f_82480_ < 0.0 && this.hasChicken()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_5803_()) {
            this.m_20256_(vector3d.m_82542_(0.0, 0.0, 0.0));
        }
        super.m_8107_();
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        if (this.hasChicken()) {
            return false;
        }
        return super.m_142535_(distance, damageMultiplier, DamageSource.f_19315_);
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.m_41720_() != Items.f_42415_ && itemStackIn.m_41720_() != Items.f_42391_ && itemStackIn.m_41720_() != Items.f_41959_ && itemStackIn.m_41720_() != Items.f_42475_ && itemStackIn.m_41720_() != Items.f_42473_ && itemStackIn.m_41720_() != Items.f_42472_ && itemStackIn.m_41720_() != Items.f_42653_ && itemStackIn.m_41720_() != Items.f_42474_ && itemStackIn.m_41720_() != Items.f_42010_ && itemStackIn.m_41720_() != Items.f_42390_ && itemStackIn.m_41720_() != Items.f_42389_ && itemStackIn.m_41720_() != Items.f_42388_ && itemStackIn.m_41720_() != Items.f_41951_ && itemStackIn.m_41720_() != Items.f_42679_ && itemStackIn.m_41720_() != Items.f_42686_ && itemStackIn.m_41720_() != Items.f_42065_ && itemStackIn.m_41720_() != Items.f_42683_ && itemStackIn.m_41720_() != Items.f_42104_ && itemStackIn.m_41720_() != Items.f_42682_ && itemStackIn.m_41720_() != Items.f_42680_ && itemStackIn.m_41720_() != Items.f_42681_ && itemStackIn.m_41720_() != Items.f_42678_ && itemStackIn.m_41720_() != Items.f_42616_ && itemStackIn.m_41720_() != Items.f_42110_ && itemStackIn.m_41720_() != Items.f_42107_ && itemStackIn.m_41720_() != Items.f_42792_ && itemStackIn.m_41720_() != Items.f_42396_ && itemStackIn.m_41720_() != Items.f_42483_ && itemStackIn.m_41720_() != Items.f_42791_ && itemStackIn.m_41720_() != Items.f_42481_ && itemStackIn.m_41720_() != Items.f_42480_ && itemStackIn.m_41720_() != Items.f_42397_ && itemStackIn.m_41720_() != Items.f_42418_ && itemStackIn.m_41720_() != Items.f_42482_ && itemStackIn.m_41720_() != Items.f_42395_ && itemStackIn.m_41720_() != Items.f_42419_ && itemStackIn.m_41720_() != Items.f_42394_ && itemStackIn.m_41720_() != Items.f_42393_ && itemStackIn.m_41720_() != Items.f_42729_ && itemStackIn.m_41720_() != Items.f_42101_ && itemStackIn.m_41720_() != Items.f_42229_ && itemStackIn.m_41720_() != Items.f_42225_ && itemStackIn.m_41720_() != Items.f_42226_ && itemStackIn.m_41720_() != Items.f_42275_ && itemStackIn.m_41720_() != Items.f_42273_ && itemStackIn.m_41720_() != Items.f_42227_ && itemStackIn.m_41720_() != Items.f_42269_ && itemStackIn.m_41720_() != Items.f_42274_ && itemStackIn.m_41720_() != Items.f_42271_ && itemStackIn.m_41720_() != Items.f_42268_ && itemStackIn.m_41720_() != Items.f_42267_ && itemStackIn.m_41720_() != Items.f_42272_ && itemStackIn.m_41720_() != Items.f_42224_ && itemStackIn.m_41720_() != Items.f_42228_ && itemStackIn.m_41720_() != Items.f_42265_ && itemStackIn.m_41720_() != Items.f_42266_ && itemStackIn.m_41720_() != Items.f_42270_ && itemStackIn.m_41720_() != Items.f_42741_ && itemStackIn.m_41720_() != Items.f_42716_ && itemStackIn.m_41720_() != Items.f_42747_ && this.f_19861_ && !this.m_5803_();
    }

    public boolean canEquipItem(ItemStack stack) {
        Item item = stack.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() && !this.hasChicken() && !this.m_5803_() || this.eatTicks > 0 && item.m_41472_() && !itemstack.m_41720_().m_41472_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ItemInit.GOBLO_SPAWN_EGG.get());
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == CreatureAttributeInit.GOBLIN) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_5757_(Container invBasic) {
    }

    class SleepGoal
    extends Goal {
        GobloEntity goblo;
        int sleepTicks = 0;

        public SleepGoal(GobloEntity goblo) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.goblo = goblo;
        }

        public boolean m_8036_() {
            return this.goblo.m_5803_();
        }

        public boolean m_8045_() {
            return this.sleepTicks < 6000 && this.goblo.m_21214_() == null;
        }

        public void m_8037_() {
            ++this.sleepTicks;
        }

        public void m_8056_() {
            this.goblo.m_6710_(null);
            GobloEntity.this.m_21573_().m_26571_();
            GobloEntity.this.m_20334_(0.0, 0.0, 0.0);
            GobloEntity.this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        }

        public void m_8041_() {
            super.m_8041_();
            this.sleepTicks = 0;
            this.goblo.setSleeping(false);
            this.goblo.m_21051_(Attributes.f_22279_).m_22100_((double)0.2f);
        }
    }

    class PickUpChickenGoal
    extends Goal {
        GobloEntity goblo;
        Chicken chicken;
        int ticks = 0;

        public PickUpChickenGoal(GobloEntity goblo) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.goblo = goblo;
        }

        public boolean m_8036_() {
            return this.goblo.m_5448_() == null && !this.goblo.hasChicken();
        }

        public void m_8037_() {
            List list = this.goblo.f_19853_.m_45976_(Chicken.class, this.goblo.m_142469_().m_82377_(8.0, 8.0, 8.0));
            if (!list.isEmpty() && !this.goblo.hasChicken()) {
                this.goblo.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list2;
            List list = this.goblo.f_19853_.m_45976_(Chicken.class, this.goblo.m_142469_().m_82377_(8.0, 8.0, 8.0));
            if (!list.isEmpty() && !this.goblo.hasChicken()) {
                this.goblo.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
            if (!(list2 = this.goblo.f_19853_.m_45976_(Chicken.class, this.goblo.m_142469_().m_82377_(1.0, 1.0, 1.0))).isEmpty() && !this.goblo.hasChicken()) {
                this.chicken = (Chicken)list2.get(0);
                this.chicken.m_20329_((Entity)this.goblo);
                this.goblo.setHasChicken(true);
            }
            if (this.goblo.m_5448_() != null) {
                this.chicken.m_8127_();
                this.goblo.setHasChicken(false);
            }
        }

        public boolean m_8045_() {
            return this.goblo.m_5448_() == null;
        }
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!GobloEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || GobloEntity.this.hasChicken()) {
                return false;
            }
            if (GobloEntity.this.m_5448_() == null) {
                if (GobloEntity.this.m_21187_().nextInt(10) != 0) {
                    return false;
                }
                List list = GobloEntity.this.f_19853_.m_45976_(ItemEntity.class, GobloEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
                return !list.isEmpty() && GobloEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = GobloEntity.this.f_19853_.m_45976_(ItemEntity.class, GobloEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            ItemStack itemstack = GobloEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                GobloEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = GobloEntity.this.f_19853_.m_45976_(ItemEntity.class, GobloEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            if (!list.isEmpty()) {
                GobloEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

